

<?php $__env->startSection('title', 'Overview Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-800">Overview Dashboard</h1>
            <p class="text-gray-600 mt-1">Complete system overview and analytics</p>
        </div>
        <a href="<?php echo e(route('admin.reports.index')); ?>" class="text-blue-600 hover:text-blue-800">
            <i class="fas fa-arrow-left mr-2"></i>Back to Reports
        </a>
    </div>

    <!-- Date Filter -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.reports.overview')); ?>" class="flex flex-col sm:flex-row gap-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="w-full px-3 py-2 border rounded">
            </div>
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">End Date</label>
                <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="w-full px-3 py-2 border rounded">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                    Filter
                </button>
            </div>
        </form>
    </div>

    <!-- Key Statistics -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-100 text-sm">Total Doctors</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['total_doctors']); ?></p>
                    <p class="text-blue-100 text-xs mt-1"><?php echo e($stats['verified_doctors']); ?> verified</p>
                </div>
                <i class="fas fa-user-md text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-100 text-sm">Total Patients</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['total_patients']); ?></p>
                </div>
                <i class="fas fa-users text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-indigo-100 text-sm">Total Prescriptions</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['total_prescriptions']); ?></p>
                </div>
                <i class="fas fa-prescription text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-teal-500 to-teal-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-teal-100 text-sm">Total Appointments</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['total_appointments']); ?></p>
                    <p class="text-teal-100 text-xs mt-1"><?php echo e($stats['completed_appointments']); ?> completed</p>
                </div>
                <i class="fas fa-calendar-check text-4xl opacity-50"></i>
            </div>
        </div>
    </div>

    <!-- Monthly Trends Chart -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h3 class="text-xl font-bold mb-4">Monthly Trends Comparison</h3>
        <canvas id="monthlyTrendsChart" height="80"></canvas>
    </div>

    <!-- Top Performing Doctors -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h3 class="text-xl font-bold mb-4">Top Performing Doctors</h3>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rank</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Doctor Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescriptions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $topDoctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-blue-100 text-blue-800 font-bold">
                                <?php echo e($index + 1); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo e($doctor->doctor_name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($doctor->prescription_count); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Additional Stats Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">System Overview</h3>
            <div class="space-y-4">
                <div class="flex justify-between items-center p-3 bg-gray-50 rounded">
                    <span class="text-gray-700">Total Branches</span>
                    <span class="font-bold text-lg"><?php echo e($stats['total_branches']); ?></span>
                </div>
                <div class="flex justify-between items-center p-3 bg-gray-50 rounded">
                    <span class="text-gray-700">Verified Doctors</span>
                    <span class="font-bold text-lg text-green-600"><?php echo e($stats['verified_doctors']); ?></span>
                </div>
                <div class="flex justify-between items-center p-3 bg-gray-50 rounded">
                    <span class="text-gray-700">Completed Appointments</span>
                    <span class="font-bold text-lg text-blue-600"><?php echo e($stats['completed_appointments']); ?></span>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Quick Links</h3>
            <div class="space-y-2">
                <a href="<?php echo e(route('admin.reports.prescriptions')); ?>" class="block p-3 bg-blue-50 hover:bg-blue-100 rounded text-blue-700">
                    <i class="fas fa-prescription mr-2"></i>Prescriptions Report
                </a>
                <a href="<?php echo e(route('admin.reports.doctors')); ?>" class="block p-3 bg-green-50 hover:bg-green-100 rounded text-green-700">
                    <i class="fas fa-user-md mr-2"></i>Doctors Report
                </a>
                <a href="<?php echo e(route('admin.reports.patients')); ?>" class="block p-3 bg-purple-50 hover:bg-purple-100 rounded text-purple-700">
                    <i class="fas fa-users mr-2"></i>Patients Report
                </a>
                <a href="<?php echo e(route('admin.reports.appointments')); ?>" class="block p-3 bg-teal-50 hover:bg-teal-100 rounded text-teal-700">
                    <i class="fas fa-calendar-check mr-2"></i>Appointments Report
                </a>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Monthly Trends Chart
    const monthlyCtx = document.getElementById('monthlyTrendsChart').getContext('2d');
    const prescriptionsData = <?php echo json_encode($monthlyPrescriptions, 15, 512) ?>;
    const appointmentsData = <?php echo json_encode($monthlyAppointments, 15, 512) ?>;
    const patientsData = <?php echo json_encode($monthlyPatients, 15, 512) ?>;
    
    // Get all unique months
    const allMonths = new Set();
    prescriptionsData.forEach(d => allMonths.add(`${d.year}-${d.month}`));
    appointmentsData.forEach(d => allMonths.add(`${d.year}-${d.month}`));
    patientsData.forEach(d => allMonths.add(`${d.year}-${d.month}`));
    
    const sortedMonths = Array.from(allMonths).sort();
    const monthLabels = sortedMonths.map(m => {
        const [year, month] = m.split('-');
        return new Date(year, month - 1).toLocaleDateString('en-US', { month: 'short', year: 'numeric' });
    });
    
    const prescriptionsCounts = sortedMonths.map(m => {
        const data = prescriptionsData.find(d => `${d.year}-${d.month}` === m);
        return data ? data.count : 0;
    });
    
    const appointmentsCounts = sortedMonths.map(m => {
        const data = appointmentsData.find(d => `${d.year}-${d.month}` === m);
        return data ? data.count : 0;
    });
    
    const patientsCounts = sortedMonths.map(m => {
        const data = patientsData.find(d => `${d.year}-${d.month}` === m);
        return data ? data.count : 0;
    });
    
    new Chart(monthlyCtx, {
        type: 'line',
        data: {
            labels: monthLabels,
            datasets: [
                {
                    label: 'Prescriptions',
                    data: prescriptionsCounts,
                    borderColor: 'rgb(99, 102, 241)',
                    backgroundColor: 'rgba(99, 102, 241, 0.1)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Appointments',
                    data: appointmentsCounts,
                    borderColor: 'rgb(20, 184, 166)',
                    backgroundColor: 'rgba(20, 184, 166, 0.1)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Patients',
                    data: patientsCounts,
                    borderColor: 'rgb(168, 85, 247)',
                    backgroundColor: 'rgba(168, 85, 247, 0.1)',
                    tension: 0.4,
                    fill: true
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/reports/overview.blade.php ENDPATH**/ ?>